/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;

public class Decorations extends Canvas {
	String text = "";
	Menu menuBar;
	Menu [] menus;

Decorations () {
}
	
public Decorations (Composite parent, int style) {
	super (parent, checkStyle (style));
}

protected void checkSubclass () {
}

static int checkStyle (int style) {
	if ((style & SWT.NO_TRIM) != 0) {
		style &= ~(SWT.CLOSE | SWT.TITLE | SWT.MIN | SWT.MAX | SWT.RESIZE | SWT.BORDER);
	}
//	if (OS.IsWinCE) {
//		/*
//		* Feature in WinCE PPC.  WS_MINIMIZEBOX or WS_MAXIMIZEBOX
//		* are not supposed to be used.  If they are, the result
//		* is a button which does not repaint correctly.  The fix
//		* is to remove this style.
//		*/
//		if ((style & SWT.MIN) != 0) style &= ~SWT.MIN;
//		if ((style & SWT.MAX) != 0) style &= ~SWT.MAX;
//		return style;
//	}
	if ((style & (SWT.MENU | SWT.MIN | SWT.MAX | SWT.CLOSE)) != 0) {
		style |= SWT.TITLE;
	}
	
	/*
	* If either WS_MINIMIZEBOX or WS_MAXIMIZEBOX are set,
	* we must also set WS_SYSMENU or the buttons will not
	* appear.
	*/
	if ((style & (SWT.MIN | SWT.MAX)) != 0) style |= SWT.CLOSE;
	
	/*
	* Both WS_SYSMENU and WS_CAPTION must be set in order
	* to for the system menu to appear.
	*/
	if ((style & SWT.CLOSE) != 0) style |= SWT.TITLE;
	
	/*
	* Bug in Windows.  The WS_CAPTION style must be
	* set when the window is resizable or it does not
	* draw properly.
	*/
	/*
	* This code is intentionally commented.  It seems
	* that this problem originally in Windows 3.11,
	* has been fixed in later versions.  Because the
	* exact nature of the drawing problem is unknown,
	* keep the commented code around in case it comes
	* back.
	*/
//	if ((style & SWT.RESIZE) != 0) style |= SWT.TITLE;
	
	return style;
}

Control computeTabGroup () {
	return this;
}

Control computeTabRoot () {
	return this;
}

public Button getDefaultButton () {
	return null;
}

public Image getImage () {
	return null;
}

public Image[] getImages () {
	return null;
}

public boolean getMaximized () {
	return false;
}

public Menu getMenuBar () {
	return null;
}

public boolean getMinimized () {
	return false;
}

public String getText () {
	checkWidget();
	return text;
}

Decorations menuShell () {
	return this;
}

void releaseChildren (boolean destroy) {
	if (menuBar != null) {
		menuBar.release (false);
		menuBar = null;
	}
	super.releaseChildren (destroy);
	if (menus != null) {
		for (int i=0; i<menus.length; i++) {
			Menu menu = menus [i];
			if (menu != null && !menu.isDisposed ()) {
				menu.dispose ();
			}
		}
		menus = null;
	}
}

public void setDefaultButton (Button button) {
}

public void setImage (Image image) {
}

public void setImages (Image[] images) {
}

public void setMaximized (boolean maximized) {
}

public void setMenuBar (Menu menu) {
}

public void setMinimized (boolean minimized) {
}

public void setText (String string) {
	checkWidget ();
	if (string == null) error (SWT.ERROR_NULL_ARGUMENT);
	text = string;
	_setText (string);
}

void _setText (String string) {
}

}
